%% settings
clear all;
Size = [1:1:2500];
div = 10;
do_it_live = 0;
desc = 'gflops_01_single';


%% setup
GFlops_cpu = zeros(length(Size),1);
GFlops_gpu = zeros(length(Size),1);
Mem_MB     = zeros(length(Size),1);
if do_it_live,
  % Create figure
  figure(1); clf(1);
  plot(Size,GFlops_cpu,'r-', Size,GFlops_gpu,'g-', 'Linewidth',1.5);
  grid;
  xlabel('Square Matrix Size, N\timesN   [-]');
  ylabel('Performance   [GFlops]');
  hold on
end


%% main
count = 0;
ii = 0;
for N=Size
    ii = ii + 1;
    A = randn(N,N,'single');
    B = randn(N,N,'single');
    RPTC = round(1E-3 * ((max(Size)-N)/div)^2 + 1);
    RPTG = round(1E-3 * ((max(Size)-N)/div)^2 + 2);
    
    fprintf('%4.0f / %4.0f', Size(ii), Size(end));
    
    % CPU
    Cc = A*B;
    Cc = A*B;
    ts = tic;
    for rpt=1:RPTC
        Cc = A*B;
    end
    tec = toc(ts)/RPTC;
    GFlops_cpu(ii) = (2*N^3)/(tec*1E9);
    fprintf('   |   %6.2f (%6.1f s)', GFlops_cpu(ii), tec*RPTC);
    
    % GPU
    Ag = gsingle(A);
    Bg = gsingle(B);
    Cg = Ag*Bg; geval(Cg);
    Cg = Ag*Bg; geval(Cg);
    gsync; ts = tic;
    for rpt=1:RPTG
        Cg = Ag*Bg;
        geval(Cg);
    end
    gsync; teg = toc(ts)/RPTG;
    GFlops_gpu(ii) = (2*N^3)/(teg*1E9);
    fprintf('   |   %6.2f (%6.1f s)', GFlops_gpu(ii), teg*RPTG);
    
    % MEM
    gpu_info = gpu_entry(13);
    Mem_MB(ii) = gpu_info.gpu_free/1E6;
    clear gpu_hook;
    fprintf('   |   Mem free [MB]: %5.1f\n', Mem_MB(ii));

    % periodically
    count = count + 1;
    if count > 5,
      count = 0;
      % live figure
      if do_it_live,
        plot(size(Size,2),GFlops_cpu,'r-', size(Size,2),GFlops_gpu,'g-', 'Linewidth',1.5);
        drawnow
      end
      % save figures
      fname = sprintf('%s_cpu',desc);
      save(fname,'GFlops_cpu');
      fname = sprintf('%s_gpu',desc);
      save(fname,'GFlops_gpu');
    end

end



%% PLOT RESULTS AND SAVE FIGURE
% Create figure
figure(1); clf(1);
plot(Size,GFlops_cpu,'r-', Size,GFlops_gpu,'g-', 'Linewidth',1.5);
grid;
xlabel('Square Matrix Size, N\timesN   [-]');
ylabel('Performance   [GFlops]');

%  Save figures
fname = sprintf('%s.jpg',desc);
print( gcf, '-djpeg99', '-r100', fname );
fname = sprintf('%s.eps',desc);
print( gcf, '-depsc2', '-r2400', fname );
fname = sprintf('%s_cpu',desc);
save(fname,'GFlops_cpu');
fname = sprintf('%s_gpu',desc);
save(fname,'GFlops_gpu');

