function [] = RUNME_Jacket_Benchmark()
% RUNME_Jacket_Benchmark   Benchmark suite to test the performance of JACKET with various functions.
clc;
fprintf('RUNME_JKT_Benchmark: This library contains a benchmark suite to test the performance\n');
fprintf('of JACKET with various functions relative to standard MATLAB running on the CPU\n');
fprintf('with all possible threads.\n');
fprintf('\n');

%% SUITE CONTENT
fprintf('The suite tests the functions:\n');
fprintf('\n');
fprintf('  - all\n');
fprintf('  - any\n');
fprintf('  - asinh\n');
fprintf('  - atan\n');
fprintf('  - atan2\n');
fprintf('  - besselj\n');
fprintf('  - chol\n');
fprintf('  - conv2\n');
fprintf('  - cos\n');
fprintf('  - det\n');
fprintf('  - exp\n');
fprintf('  - fft\n');
fprintf('  - find\n');
fprintf('  - ifft\n');
fprintf('  - interp2\n');
fprintf('  - inv\n');
fprintf('  - log\n');
fprintf('  - lu\n');
fprintf('  - max\n');
fprintf('  - min\n');
fprintf('  - minus\n');
fprintf('  - mldivide\n');
fprintf('  - mpower\n');
fprintf('  - norm\n');
fprintf('  - plus\n');
fprintf('  - power\n');
fprintf('  - rand\n');
fprintf('  - randn\n');
fprintf('  - rdivide\n');
fprintf('  - sort\n');
fprintf('  - subsasgn\n');
fprintf('  - times\n');
fprintf('  - trapz\n');
fprintf('\n');

%% MORE INFORMATION
fprintf('For more information see:\n');
fprintf('  http://wiki.accelereyes.com/wiki/index.php/Torben''s_Corner:_Jacket_Benchmark_Tables\n');
fprintf('  (C) Torben Larsen, Aalborg University, Denmark. tl@es.aau.dk\n');
fprintf('\n');

%% EXAMPLE
fprintf('Example:\n');
fprintf('  To use the benchmark suite, a master file must be made, which explains what matrix/vector\n');
fprintf('  sizes to use, where to place data etc. Some example files exist in the library - for\n');
fprintf('  example the m-file ''master_GPU_TYPE''. First this file should be renamed to whatever\n');
fprintf('  GPU you have available. Say you have a GeForce GT330M. In this case rename the file\n');
fprintf('  ''master_GPU_TYPE'' to ''master_GeForce_GT330M.m''.\n');
fprintf('\n');
fprintf('  After this, open the file ''master_GeForce_GT330M'' and edit as you find relevant. The\n');
fprintf('  most obvious way to edit is something like:\n');
fprintf('\n');
fprintf('    %%%% INPUT DATA\n');
fprintf('    %%  Square matrix size\n');
fprintf('    MatSz = 1500;\n');
fprintf('\n');
fprintf('    %% Vector length\n');
fprintf('    VecSz = 2.25E6;\n');
fprintf('\n');
fprintf('    %% String for GPU under test\n');
fprintf('    gstr = ''GeForce GT330M'';\n');
fprintf('\n');
fprintf('    %% String for CPU under test\n');
fprintf('    cstr = ''Core i7-975'';\n');
fprintf('\n');
fprintf('    %% File name for data storage (excluding extension - NO SPACES)\n');
fprintf('    fname = ''GeForce_GT330M_01'';\n');
fprintf('\n');
fprintf('    %% Update path and run benchmark\n');
fprintf('    addpath(''lib'');\n');
fprintf('    bench_master( MatSz, VecSz, fname, gstr, cstr );\n');
fprintf('\n');
fprintf('  With this in place it is just to run the file ''master_GeForce_GT330M.m''. The\n');
fprintf('  benchmark usually takes 1.5-2 hours to complete, and the computer should not be\n');
fprintf('  used while performing the benchmark. Otherwise the results may not be reproducible.\n');
fprintf('\n');
fprintf('  After the benchmark has completed, three files are generated in the directory:\n');
fprintf('\n');
fprintf('    benchmarks/GeForce_GT330M/\n');
fprintf('\n');
fprintf('  The files are:\n');
fprintf('\n');
fprintf('    ''fname''.tex   >>   A Latex table, which can directly be processed by Latex.\n');
fprintf('    ''fname''.wki   >>   A Wiki table, which can directly be copied into a Wiki page.\n');
fprintf('    ''fname''.mat   >>   A file containing all the measured data.\n');
fprintf('\n');
fprintf('    The name ''fname'' is in this case ''GeForce_GT330M_01'' defined in the master file\n');
fprintf('    ''master_GeForce_GT330M.m''.\n)');
%

end