% GPROFILE GPU Profiling, CPU comparison, Automatic Error Checking
% 
%   Usage:
%
%   GPROFILE ON: turns on the GPU profiling mechanism, hooks, and will clear
%   all previous gprofile state.
%
%   GPROFILE OFF: gprofile off turns off GPU profiling.
%   
%   GPROFILE REPORT provides a command by command summary of GPU runtimes, CPU
%   runtimes, and comparisons. When called from desktop- mode MATLAB, the
%   report is colored such that red lines indicate commands that on average
%   are faster on the GPU whereas green lines are faster on the GPU. For
%   ubiquity, the ASCII characters ^ and V provide similar indications when a
%   color console is not available.
%   
%   GPROFILE REPORT [COMMAND NAME]: similar to GPROFILE REPORT and restricts
%   output to a given command name. Timings are given for the given command on
%   a per file and line basis for both the GPU and CPU wih comparisons
%   Illustration: Command GPROFILE report.  Each item in the report includes a
%   line of the original source code at which the command was called.
%   
%   GPROFILE REPORT [COMMAND NAME] [FILE]: similar to GPROFILE REPORT [command
%   name] with information restricted to the given command inside the given
%   file. Timings are given for the given command on a use case (data size,
%   shape, access patteen) basis for both the GPU and CPU with
%   comparisons. Helpful for understanding on what data sizes GPU is
%   advantageous and what access patterns are optimal (e.g. sum on columns
%   SUM(A,1) versus sum on rows SUM(A,2)).
%   
%   GPROFILE report [COMMAND NAME] [FILE] [LINE NO]: similar to gprofile
%   report [COMMAND NAME] [FILE] with information restricted to the given
%   command inside the given file and line number. Helpful for understanding
%   the common sizes of input data a command runs on and what sizes are most
%   efficient.
%   
%   Example:
%   gprofile on
%   N = 2e3;
%   for i=1e3:1e2:N, fprintf('%d/%d\n', i, N);
%     A = grand(i);
%     C = conv2(ones(3,1), ones(3,1), A, 'same');
%   end
%   gprofile off
%   gprofile report
%
%   See Also
%   GPROFVIEW
%
