<?php
/*
Plugin Name: WP Archive-Sitemap Generator
Plugin URI: http://netcrunched.com/plugins/wp-archive-sitemap-generator/
Description: WP Archive-Sitemap Generator plugin Generates simple Archives/Sitemap based on your posts and pages. This is not another XML sitemap plugin.
Version: 4.5.3
Author: NetCrunched
Author URI: http://netcrunched.com
*/

/*
    Copyright (C) 2012 NetCrunched.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


require_once "Paginated.php";
require_once "DoubleBarLayout.php";

//To replace the <!--wp-archive-sitemap-generator--> with the actual sitemap
function wp_archive_sitemap_generator($text) {
	global $wpdb, $table_prefix;

	//If this text included in pages or posts? <!--wp-archive-sitemap-generator-->
	if (preg_match("|<!--wp-archive-sitemap-generator-->|", $text)) {

		//Here you can get option values
		$wp_simple_order = get_option('wp_archive_sitemap_generator_order');
		$wp_page_checked = get_option('wp_archive_sitemap_generator_page');
		$wp_comment_checked = get_option('wp_archive_sitemap_generator_comment');
		$wp_post_count = get_option('wp_archive_sitemap_generator_post_count');
		$wp_sitemap_show_sponsor_link = get_option('wp_archive_sitemap_generator_sponsor');

		//do the order by
		switch ($wp_simple_order) {
			case 'sort_desc':
				$sqlorder = "ORDER BY post_date DESC";
				break;
			case 'sort_asc':
				$sqlorder = "ORDER BY post_date";
				break;
			case 'sort_abc':
				$sqlorder = "ORDER BY post_title";
				break;
			case 'sort_xyz':
				$sqlorder = "ORDER BY post_title DESC";
				break;
		}

		$sqlwhere = "WHERE post_type='post' AND post_status='publish' ";

		$sql = "SELECT * FROM " . $table_prefix . "posts " . $sqlwhere . $sqlorder;

		$allposts = $wpdb->get_results($sql);

		$postcounter = 0;
		$postheader = "BLOG SITEMAP:";
		$postend = "WP Archive-Sitemap Generator";
		foreach($allposts as $ap)
		{
			$perma = get_permalink($ap->ID);
			$postcounter++;
			$posts = '<b>' . $postcounter . '.</b>&nbsp;&nbsp;' . '<a href=' . $perma . '>' . $ap->post_title . '</a>';

			if ($wp_comment_checked == 'on')
			{
				$posts = $posts . ' (' . $ap->comment_count . ')<br/>';
			}else
			{
				$posts = $posts . '<br />';
			}

			$arrayposts[] = $posts;
		}

		$posts = '<b><i>'.'Posts (' . $postcounter . ') &nbsp; </i></b><br/>';

		if (!($wp_page_checked == 'on'))
		{
			$posts = '<br />'.$posts;
		}

		//show pages
		$pagecounter = 0;
		if ($wp_page_checked == 'on') {

			$sqlpage = "SELECT * FROM " . $table_prefix . "posts where post_type='page' AND post_status='publish'";
			$allpages = $wpdb->get_results($sqlpage);

			foreach($allpages as $ap) {
				$perma = get_permalink($ap->ID);
				$pagecounter++;

				$pages .= '&nbsp;&nbsp;&nbsp;<b>' . $pagecounter . '.</b>&nbsp;&nbsp;' . '<a href=' . $perma . '>' . $ap->post_title . '</a><br/>';
			}
			$pages = '<b><i><br />'.'Pages (' . $pagecounter . ') &nbsp;</i></b><br/>' .$pages;
		}

		//pagination (100 posts per page)
		$page = $_GET['page'];
		$pagedResults = new Paginated($arrayposts, $wp_post_count, $page);
		while($row = $pagedResults->fetchPagedRow()) {	//when $row is false loop terminates
			$row1 .= '&nbsp;&nbsp;&nbsp;' . $row;
		}

		//important to set the strategy to be used before a call to fetchPagedNavigation
		$pagedResults->setLayout(new DoubleBarLayout());
		$pagedResult1 = $pagedResults->fetchPagedNavigation();

		$pluginlink = "http://netcrunched.com/plugins/wp-archive-sitemap-generator/";
		$target1 = "_blank";


		if($wp_sitemap_show_sponsor_link == 'on')
		{
			$sponsor_link1 = "";
		}
		else
		{
			$sponsor_link1 = '<font size="1"><br/><i> Generated by: <a href="http://netcrunched.com/plugins/wp-archive-sitemap-generator/" target="_blank">WP Archive-Sitemap Generator</a></i></font>';
		}

		$text = preg_replace("|<!--wp-archive-sitemap-generator-->|", '<b>'. $postheader .'</b>'. $pages . '' .$posts . $row1 . '<br />' . $pagedResult1 , $text);
	}

	return $text;

} //end wp_archive_sitemap_generator()


//admin menu
function wp_archive_sitemap_generator_admin() {
	if (function_exists('add_options_page')) {
		add_options_page('wp-archive-sitemap-generator', 'Archive-Sitemap', 1, basename(__FILE__), 'wp_archive_sitemap_generator_admin_panel');
  }
}

function wp_archive_sitemap_generator_admin_panel() {

	//If this is first time running add default option
	add_option('wp_archive_sitemap_generator_order', 'sort_desc', 'WP Archive-Sitemap Generator Plugin');
	add_option('wp_archive_sitemap_generator_page', 'false', 'WP Archive-Sitemap Generator Plugin');
	add_option('wp_archive_sitemap_generator_comment', 'false', 'WP Archive-Sitemap Generator Plugin');
	add_option('wp_archive_sitemap_generator_post_count', '100', 'WP Archive-Sitemap Generator Plugin');

	add_option('wp_archive_sitemap_generator_sponsor', 'false', 'WP Archive-Sitemap Generator Plugin');

	//get posted options
	$wp_simple_order = $_POST['wp_simple_order'];
	$wp_post_count = $_POST['wp_post_count'];

	if (isset($_POST['option_value'])) {
		//update settings
		$wp_simple_order = $_POST['wp_simple_order'];
		$wp_page_checked = $_POST['wp_page_checked'];
		$wp_post_count = $_POST['wp_post_count'];
		$wp_comment_checked = $_POST['wp_comment_checked'];

		$wp_sitemap_show_sponsor_link = $_POST['wp_sitemap_show_sponsor_link'];

		update_option('wp_archive_sitemap_generator_order', $wp_simple_order);
		update_option('wp_archive_sitemap_generator_page', $wp_page_checked);
		update_option('wp_archive_sitemap_generator_comment', $wp_comment_checked);
		update_option('wp_archive_sitemap_generator_post_count', $wp_post_count);

		update_option('wp_archive_sitemap_generator_sponsor', $wp_sitemap_show_sponsor_link);

		echo '<div id="message" class="updated fade"><p><strong>Settings saved.</strong></p></div>';

	} else {
		$wp_simple_order = get_option('wp_archive_sitemap_generator_order');
		$wp_page_checked	= get_option('wp_archive_sitemap_generator_page');
		$wp_comment_checked	= get_option('wp_archive_sitemap_generator_comment');
		$wp_post_count	= get_option('wp_archive_sitemap_generator_post_count');

		$wp_sitemap_show_sponsor_link = get_option('wp_archive_sitemap_generator_sponsor');

	}

	?>

<style type="text/css">
	body {
		font-family: Verdana;
		font-size: 13px;
	}

	a {
		text-decoration: none;
	}

	a:hover {
		text-decoration: underline;
	}
</style>

	<div class=wrap>
		<form method="post">

		<h2>WP Archive-Sitemap Generator Options</h2>

		<div id="poststuff" class="metabox-holder has-right-sidebar">

		<div style="float:left;width:60%;">

<iframe src="//www.facebook.com/plugins/like.php?href=http%3A%2F%2Fwww.facebook.com%2Fpages%2FNetCrunched%2F310777122307297&amp;send=false&amp;layout=standard&amp;width=450&amp;show_faces=false&amp;action=like&amp;colorscheme=light&amp;font&amp;height=35" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:450px; height:35px;" allowTransparency="true"></iframe>

			<div class="postbox">
				<h3>Sitemap Options</h3>
				<div>

					<table class="form-table">
					<tr valign="top" class="alternate">
						<th scope="row"><label>Post Sorting Order</label></th>
						<td>
							<input name="wp_simple_order" type="radio" value="sort_desc" <?php checked('sort_desc', $wp_simple_order); ?> class="tog"/>
					By post date (newest first) (default)

						</td>
					</tr>
					<tr valign="top">
						<th scope="row"></th>
						<td>
							<input name="wp_simple_order" type="radio" value="sort_asc" <?php checked('sort_asc', $wp_simple_order); ?> class="tog"/>
						By post date (oldest first)

						</td>
					</tr>
					<tr valign="top" class="alternate">
						<th scope="row"></th>
						<td>
							<input name="wp_simple_order" type="radio" value="sort_abc" <?php checked('sort_abc', $wp_simple_order); ?> class="tog"/>
						By Title (A to Z order)

						</td>
					</tr>
					<tr valign="top">
						<th scope="row"></th>
						<td>
							<input name="wp_simple_order" type="radio" value="sort_xyz" <?php checked('sort_xyz', $wp_simple_order); ?> class="tog"/>
						By Title (Z to A order)

						</td>
					</tr>

					<tr valign="top" class="alternate">
						<th scope="row"><label>Include Pages?</label></th>
						<td>
							<input name="wp_page_checked" type="checkbox" <?php checked('on', $wp_page_checked); ?> class="tog"/>
							Show pages (default unchecked)
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><label>Number of posts per page</label></th>
						<td>
							<input name="wp_post_count" type="radio" value="50" <?php checked('50', $wp_post_count); ?> class="tog"/>
						50 posts/page

						</td>
					</tr>
					<tr valign="top" class="alternate">
						<th scope="row"></th>
						<td>
							<input name="wp_post_count" type="radio" value="100" <?php checked('100', $wp_post_count); ?> class="tog"/>
						100 posts/page (default)

						</td>
					</tr>
					<tr valign="top">
						<th scope="row"></th>
						<td>
							<input name="wp_post_count" type="radio" value="150" <?php checked('150', $wp_post_count); ?> class="tog"/>
						150 posts/page

						</td>
					</tr>
					<tr valign="top" class="alternate">
						<th scope="row"></th>
						<td>
							<input name="wp_post_count" type="radio" value="200" <?php checked('200', $wp_post_count); ?> class="tog"/>
						200 posts/page

						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><label>Show Comments?</label></th>
						<td>
							<input name="wp_comment_checked" type="checkbox" <?php checked('on', $wp_comment_checked); ?> class="tog"/>
							Show comments (default unchecked)
						</td>
					</tr>

					<tr valign="top" class="alternate">
						<th scope="row"><label>Show "Generated by.." link after sitemap?</label></th>
						<td>
							<input name="wp_sitemap_show_sponsor_link" type="checkbox" <?php checked('on', $wp_sitemap_show_sponsor_link); ?> class="tog"/>
							<code>Check</code> to hide
						</td>
					</tr>


					</table>
				</div>
			</div>



			<div class="submit">
				<input type="submit" name="option_value" class="button-primary" value="<?php _e( 'Update Options' ); ?>" />
			</div>

		</form>
</div>

		 <div id="side-info-column" class="inner-sidebar">
				<div class="postbox">
				  <h3 class="hndle"><span>WP Archive-Sitemap Generator</span></h3>
				  <div class="inside">
	                <ul>
	                <li><a href="http://netcrunched.com/plugins/wp-archive-sitemap-generator/" title="WP Archive-Sitemap Generator" target="_blank">Plugin Homepage</a></li>
	                </ul>
	              </div>

<div class="inside">
<b>Subscribe to get latest update:</b>
<iframe src="//www.facebook.com/plugins/likebox.php?href=http%3A%2F%2Fwww.facebook.com%2Fpages%2FNetCrunched%2F310777122307297&amp;width=292&amp;height=62&amp;colorscheme=light&amp;show_faces=false&amp;border_color&amp;stream=false&amp;header=false" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:292px; height:62px;" allowTransparency="true"></iframe>
<a href="https://twitter.com/NetCrunched" class="twitter-follow-button" data-show-count="false">Follow @NetCrunched</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>
</div>

				</div>
     </div>
          <br>
			<div id="side-info-column" class="inner-sidebar">
				<div class="postbox">
				  <h3 class="hndle"><span>My Other Plugins</span></h3>
				  <div class="inside">
					<ul>
					<li>1) <a href="http://netcrunched.com/plugins/twitter-goodies/" title="Twitter Goodies" target="_blank">Twitter Goodies</a></li>
					<li>2) <a href="http://netcrunched.com/plugins/wp-google-buzz/" title="WP Google-buzz" target="_blank">WP Google-buzz</a></li>
					<li>3) <a href="http://netcrunched.com/plugins/all-in-one-webmaster/" title="All in One Webmaster" target="_blank">All in One Webmaster</a></li>
					<li>4) <a href="http://netcrunched.com/plugins/foursquare-integration/" title="FourSquare Integration" target="_blank">FourSquare Integration</a></li>
					<li>5) <a href="http://netcrunched.com/plugins/facebook-members/" title="Facebook Members" target="_blank">Facebook Members</a></li>
					</ul>
				  </div>
				</div>
		     </div>


	</div>

		</div>
	</div><?php
}


//hooks
add_filter('the_content', 'wp_archive_sitemap_generator', 2);
add_action('admin_menu', 'wp_archive_sitemap_generator_admin');

?>