<?php
class Accelereyes_Version_AdminController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {

        $this->loadLayout()
                ->_addContent($this->getLayout()->createBlock('version/admin_main'))
                ->renderLayout();

    }

    public function deleteAction()
    {

        $versionId = $this->getRequest()->getParam('id', false);

        try {

            Mage::getModel('version/version')->setId($versionId)->delete();
            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('version')->__('Version deleted successfully.'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));

            return;

        } catch (Exception $e) {

            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

        }

        $this->_redirectReferer();

    }

    public function newAction()
    {

        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('version/admin_new'))
            ->renderLayout();

    }

    public function postAction()
    {

        if ($data = $this->getRequest()->getPost()) {
            $data['date'] = strtotime($data['date']);
            $version = Mage::getModel('version/version')->setData($data);
            try {
                $version->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('version')->__('Version created successfully.'));
                $this->getResponse()->setRedirect($this->getUrl('*/*/'));
                return;

            } catch (Exception $e) {

                die($e->getMessage());
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

       }

       $this->getResponse()->setRedirect($this->getUrl('*/*/'));
       return;

    }

    public function editAction()
    {

        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('version/admin_edit'));
        $this->renderLayout();

    }

    public function saveAction()
    {

        $versionId = $this->getRequest()->getParam('id', false);
        if ($data = $this->getRequest()->getPost()) {

            $data['date'] = strtotime($data['date']);
            $version = Mage::getModel('version/version')->load($versionId)->addData($data);
            try {
                $version->setId($versionId)->save();

                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('version')->__('Version updated successfully.'));
                $this->getResponse()->setRedirect($this->getUrl('*/*/'));

                return;

            } catch (Exception $e) {

                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

        }

        $this->_redirectReferer();

    }

}
