<?php

class Accelereyes_Version_Block_Admin_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $form = new Varien_Data_Form(array(
            'id'        => 'edit_form',
            'action'    => $this->getUrl('*/*/save', array('id' =>
                                                     $this->getRequest()->getParam('id'))),
            'method'    => 'post'
        ));

        $fieldset = $form->addFieldset('edit_version', array('legend' =>
                                                        Mage::helper('version')->__('Version Details')));
        $fieldset->addField('version_number', 'text', array(
            'name'      => 'version_number',
            'title'     => Mage::helper('version')->__('Version Number'),
            'label'     => Mage::helper('version')->__('Version Number'),
            'maxlength' => '10',
            'required'  => true,
        ));

        $fieldset->addField('date', 'date', array(
            'name'      => 'date',
            'title'     => Mage::helper('version')->__('Date'),
            'label'     => Mage::helper('version')->__('Date'),
            'align'     => 'right',
            'image'     => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'    => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'  => true,
        ));

        $fieldset->addField('mst_pin', 'text', array(
            'name'      => 'mst_pin',
            'title'     => Mage::helper('version')->__('Master Pin'),
            'label'     => Mage::helper('version')->__('Master Pin'),
            'maxlength' => '10',
            'required'  => false,
        ));

        $form->setUseContainer(true);
        $form->setValues(Mage::registry('frozen_version')->getData());
        $this->setForm($form);
        return parent::_prepareForm();

    }

}
