<?php

class Accelereyes_Reseller_AdminController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {

      $this->loadLayout()
        ->_addContent($this->getLayout()->createBlock('reseller/admin_main'))
        ->renderLayout();

    }

    public function deleteAction()
    {

      $resellerId = $this->getRequest()->getParam('id', false);

      try {
          Mage::getModel('reseller/reseller')->setId($resellerId)->delete();
          Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('reseller')->__('Reseller
              deleted successfully.'));
          $this->getResponse()->setRedirect($this->getUrl('*/*/'));

          return;
      } catch (Exception $e) {
        Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
      }

      $this->_redirectReferer();

    }

    public function newAction()
    {

      $this->loadLayout()
        ->_addContent($this->getLayout()->createBlock('reseller/admin_new'))
        ->renderLayout();

    }

    public function postAction()
    {

      if($data = $this->getRequest()->getPost()) {
        $reseller = Mage::getModel('reseller/reseller')->setData($data);
        error_log(print_r($data, true));
        try {
            $reseller->save();
            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('reseller')->__('Reseller successfully saved.'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));
            return;
        } catch (Exception $e) {
          die($e->getMessage());
          Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }
        $this->getResponse()->setRedirect($this->getUrl('*/*/'));
        return;

      }

    }

    public function editAction()
    {

      $this->loadLayout();
      $this->_addContent($this->getLayout()->createBlock('reseller/admin_edit'));
      $this->renderLayout();

    }

    public function saveAction()
    {

      $resellerId = $this->getRequest()->getParam('id', false);
      if ($data = $this->getRequest()->getPost()) {
         $reseller = Mage::getModel('reseller/reseller')->load($resellerId)->addData($data);
         try {
             $reseller->setId($resellerId)->save();

             Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('reseller')->__('Reseller
                                                         was saved successfully'));
             $this->getResponse()->setRedirect($this->getUrl('*/*/'));
             return;
         } catch (Exception $e) {
             Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
         }

      }

    }

    public function ordersAction()
    {

      $this->loadLayout()
          ->_addContent($this->getLayout()->createBlock('reseller/admin_orders'))
          ->renderLayout();

    }

    public function editOrderAction()
    {

      $this->loadLayout();
      $this->_addContent($this->getLayout()->createBlock('reseller/admin_editOrder'));
      $this->renderLayout();

    }

    public function saveOrderAction()
    {

      $resellerOrderId = $this->getRequest()->getParam('id', false);
      error_log($resellerOrderId);
      if ($data = $this->getRequest()->getPost()) {
         $resellerOrder = Mage::getModel('reseller/resellerOrder')->load($resellerOrderId)->addData($data);
         try {
             $resellerOrder->setId($resellerOrderId)->save();
             $resellerOrder->save();
             Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('reseller')->__('Reseller
                 Order was saved successfully'));
             $this->getResponse()->setRedirect($this->getUrl('*/*/orders'));
             return;
         } catch (Exception $e) {
             Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
         }

      }


    }

    public function deleteOrderAction()
    {

      $resellerOrderId = $this->getRequest()->getParam('id', false);

      try {
          Mage::getModel('reseller/resellerOrder')->setId($resellerOrderId)->delete();
          Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('reseller')->__('Reseller
              Order record deleted successfully.'));
          $this->getResponse()->setRedirect($this->getUrl('*/*/orders/'));

          return;
      } catch (Exception $e) {
        Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
      }

      $this->_redirectReferer();

    }


}

