<?php

class Accelereyes_Reseller_Block_Admin_EditOrder extends Mage_Adminhtml_Block_Widget_Form_Container
{

    public function __construct()
    {

        $this->_objectId = 'id';
        $this->_blockGroup = 'reseller';
        $this->_mode = 'editOrder';
        $this->_controller = 'admin';

        if($this->getRequest()->getParam($this->_objectId))
        {

            $resellerOrderData = Mage::getModel('reseller/resellerOrder')
                ->load($this->getRequest()->getParam($this->_objectId));
            Mage::register('frozen_resellerOrder', $resellerOrderData);

        }

        parent::__construct();

        $this->_updateButton('back', 'onclick',
            'setLocation(\'http://sandbox.accelereyes.com/index.php/admin/reseller/orders\')');

        $this->_updateButton('delete', 'onclick',
            'deleteConfirm(\'Are you sure?\', \'' . Mage::getBaseUrl()
            . 'admin/reseller/deleteOrder/id/'
            . $this->getRequest()->getParam($this->_objectId)
            . '\')'
        );

    }

    public function getHeaderText()
    {

        return Mage::helper('reseller')->__("Edit Reseller Order '%s'", $this->htmlEscape(Mage::registry('frozen_resellerOrder')->getOrderId()));

    }

}
