<?php

class Accelereyes_Qla_Model_Observer extends Mage_Core_Model_Abstract
{

  const QLA_NOTIFICATION_EMAIL = "sales@massiveanalytics.com";

  /**
   * Record the license information for QLA products.
   *
   * @triggeredby: sales_order_place_after
   * @param $observer array "order"=>$order
   */
  public function qlaOrder($observer)
  {
    date_default_timezone_set('EST');

    $qlaSkus = array();
    $qlaSkus[] = 'QLA-SINGLE';
    $qlaSkus[] = 'QLA-MULTI';
    $qlaSkus[] = 'QLA-SITE';

    $order = $observer->getEvent()->getOrder();
    $items = $order->getItemsCollection();

    if(Mage::getSingleton('customer/session')->getCurrentOrder() != $order->getIncrementId()) {
      Mage::getSingleton('customer/session')->setCurrentOrder($order->getIncrementId());
    } else {
      return;
    }

    $customerId = Mage::getModel('customer/session')->getCustomerId();

    $customer = Mage::getModel('customer/customer')->load($customerId);
    if ($customer != null) $customer = $customer->getData();

    $message = "New QLA Order Placed:\n\n";
    $message .= "--- Customer Information ---\n";

    if (array_key_exists("firstname", $customer)) $message .= $customer['firstname'];
    $message .= " ";
    if (array_key_exists("lastname", $customer)) $message .= $customer['lastname'];

    $message .= "\n";

    if (array_key_exists("email", $customer)) $message .= $customer['email'] . "\n";
    if (array_key_exists("company", $customer)) $message .= $customer['company'] . "\n";
    if (array_key_exists("occupation", $customer)) $message .= $customer['occupation'] . "\n";

    $message .= "\n";

    $message .= "\n--- Order Information ---\n";
    $message .= "Date: " . date("Y-m-d g:i:s a") . "\n\n";

    $hasQla = false;
    
    foreach($items as $item) {
      if($item->getParentItem()) { continue; }
      $itemSku = $item->getSku();
      if(!in_array($itemSku, $qlaSkus)) { continue; }
      $qty = $item->getQtyOrdered();

      $hasQla = true;

      $message .= $itemSku . ": qty" . $qty . ", $" . $item->getPrice()  . "\n";

      for($i=0;$i<$qty;$i++) {
	$qlaLicense = Mage::getModel('qla/qla');
	$qlaLicense->setDate(time());
	$qlaLicense->setVersion('qla.v1');
	switch($itemSku) {
	  case 'QLA-SINGLE':
	    $qlaLicense->setType('single');
	    break;
	  case 'QLA-MULTI':
	    $qlaLicense->setType('multi');
	    break;
	  case 'QLA-SITE':
	    $qlaLicense->setType('site');
	    break;
	}
	$qlaLicense->setCustomerId($customerId);	
	$qlaLicense->save();
      }
    }

    try{
      if ($hasQla){
        mail(self::QLA_NOTIFICATION_EMAIL, "QLA Purchase Notification", $message);
      }
    }
    catch (Exception $e){
      error_log("Error when attempting to send QLA notification email");
      error_log(print_r($e, true));
    }
  }
}