<?php

class Accelereyes_Pdf_IndexController extends Mage_Core_Controller_Front_Action
{

  public function indexAction()
  {
    $productModel = Mage::getModel('catalog/product')
      ->setStoreId(Mage::app()->getStore()->getId());
    $storeModel = Mage::getModel('core/store');
    $customer = Mage::getModel('customer/customer')->load(Mage::getModel('customer/session')->getCustomerId());
    $pdf = new Zend_Pdf();
    $pdfPage= new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_LETTER);
    
    $width = $pdfPage->getWidth();
    $height = $pdfPage->getHeight();
    
    $colorBlack = new Zend_Pdf_Color_GrayScale(0.0);
    $colorJacketYellow = new Zend_Pdf_Color_Html('#ffd10f');
    $font = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_TIMES);
    $boldFont = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_TIMES_BOLD);

    $pdfPage = $this->drawQuoteHeader($pdfPage, $height, $width, array('font'=>$font, 'bold'=>$boldFont));
    $pdfPage = $this->drawQuoteGrid($pdfPage, $height, $width, $font, $boldFont, $colorJacketYellow, $colorBlack, $customer);

    $session = Mage::getSingleton('checkout/session');
    $items = $session->getQuote()->getAllItems();

    $pIds = array();

    foreach($items as $item) {
      $pIds[$item['product_id']] = $item['qty'];
    }

    $pdfPage->setFont($font, 8);
    $currentY = $height - 275;
    $maxDescLength = 65;
    $columnTotal = 0;

    foreach($pIds as $pId => $qty)
    {
      $product = $productModel
        ->load($pId);
      $name = $product->getName();
      $sku = $product->getSku();
      $desc = $product->getShortDescription();
      $desc = explode(' ', $desc);
      $price = $product->getPrice();
      $tierPrice = $product->getTierPrice('price');
      $total = $qty * $tierPrice;
      $columnTotal = $columnTotal + $total;
      $pdfPage->drawText($qty, 25, $currentY);
      $pdfPage->drawText($sku, 55, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($price)), 395, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($tierPrice)), 465, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($total)), 530, $currentY);

      $currLine = '';
      /** Quick and dirty Word Wrap **/
      foreach($desc as $word)
      {
        $word = strip_tags($word);
        if($word == '') { continue; }
        if(strlen($currLine) + strlen($word) > $maxDescLength)
        {
          $pdfPage->drawText($currLine, 140, $currentY);
          $currLine = $word;
          $currentY -= 15;
        }
        else
        {
          $currLine = $currLine . ' ' . $word;
        }
      }
      $pdfPage->drawText($currLine, 140, $currentY);

      if($currentY <= 35) {
	$pdf->pages[] = $pdfPage;
        $pdfPage= new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_LETTER);
	$currentY = $height - 35;
	$pdfPage->setFont($font, 8);
      }

      $currentY -= 20;

    }

    /** Draw total box **/
    $pdfPage->setFillColor($colorJacketYellow);
    $pdfPage->setFont($boldFont, 14);
    $pdfPage->drawLine(35, $currentY, 400, $currentY);
    $pdfPage->drawRectangle(425, $currentY, $width-15, $currentY-20);

    /** Draw Total  **/
    $pdfPage->setFillColor($colorBlack);
    $pdfPage->drawText('Total:      ' . strip_tags($storeModel->formatPrice($columnTotal)), 445, $currentY-15); 

    $currentY -= 15;

    if($currentY <= 160) {
      $pdf->pages[] = $pdfPage;
      $pdfPage= new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_LETTER);
      $currentY = $height - 35;
      $pdfPage->setFont($font, 8);
    }

    $pdfPage = $this->drawQuoteFooter($pdfPage, 160, $height, $width, $boldFont);

    $pdf->pages[] = $pdfPage;
    $pdfData = $pdf->render();
    header("Conent-Disposition: inline; filename=\"AccelerEyes_Jacket_Quote.pdf\"");
    header("Content-type: application/x-pdf");
    echo $pdfData;
  }

  private function drawQuoteHeader($pdfPage, $height, $width, $fonts)
  {
    $font = $fonts['font'];
    $boldFont = $fonts['bold'];

    /** Draw the logo **/
    $logo = Zend_Pdf_Image::imageWithPath(Mage::getBaseDir() . '/skin/frontend/default/six/images/accelereyes_logo_pdf.png');
    $pdfPage->drawImage($logo, 15 , $height-75, 160, $height-15);

    /** Write the "Quote" header **/
    $pdfPage->setFont($font, 36);
    $pdfPage->drawText('QUOTE', 450, $height-40);

    /** Write the date **/
    $pdfPage->setFont($boldFont, 12);
    $pdfPage->drawText('Date: ', 450, $height-60);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText(date('M d, Y', time()), 485,$height-60);

    /** Write the quote number **/
    $pdfPage->setFont($boldFont, 12);
    $pdfPage->drawText('Quote #: ', 434, $height-73);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText(time(), 485,$height-73);

    $pdfPage = $this->drawAddress($pdfPage, $height, $width, $font);

    return $pdfPage;

  }

  private function drawAddress($pdfPage, $height, $width, $font)
  {
    /** Write the address info **/
    $spacing = 15;
    $offset = 22;
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText('75 5th St. NW Suite 204', 175, $height-$offset);
    $pdfPage->drawText('Atlanta, GA 30308', 175, $height - $offset - $spacing);
    $pdfPage->drawText('USA', 175, $height - $offset - $spacing*2);
    $pdfPage->drawText('T: 800-570-1941  F:678-303-3409', 175, $height - $offset - $spacing*3);
    return $pdfPage;
  }

  private function drawQuoteGrid($pdfPage, $height, $width, $font, $bold, $fillColor, $fontColor, $customer)
  {
    /** Draw the Rectangles for the grid **/
    $pdfPage->setFillColor(new Zend_Pdf_Color_GrayScale(1.0));
    $pdfPage->drawRectangle(15, $height-90, $width/2.5, $height-225);
    $pdfPage->setFillColor($fillColor);
    $pdfPage->drawRectangle(15, $height-90, $width/2.5, $height-105);
    $pdfPage->drawRectangle(15, $height-230, $width-15, $height-255);
    $pdfPage->drawRectangle(15, $height-245, 45, $height-260);
    $pdfPage->drawRectangle(45, $height-245, 130, $height-260);
    $pdfPage->drawRectangle(130, $height-245, 380, $height-260);
    $pdfPage->drawRectangle(380, $height-245, 450, $height-260);
    $pdfPage->drawRectangle(450, $height-245, 520, $height-260);
    $pdfPage->drawRectangle(520, $height-245, $width-15, $height-260);

    /** Populate the grid boxes **/
    $pdfPage->setFont($font, 12);
    $pdfPage->setFillColor($fontColor);
    $pdfPage->drawText('Sold To', 19, $height-102);
    $pdfPage->drawText('Quote Valid for 30 Days', $width-145, $height-242);
    $pdfPage->drawText('Qty', 19, $height-257);
    $pdfPage->drawText('SKU', 75, $height-257);
    $pdfPage->drawText('Description', 230, $height-257);
    $pdfPage->drawText('List Price', 389, $height-257);
    $pdfPage->drawText('Unit Price', 459, $height-257);
    $pdfPage->drawText('Ext. Price', 526, $height-257);


    if($defaultBilling = $customer->getDefaultBilling()) {
      $address = $customer->getAddressById($defaultBilling);
    /* } */
    /* $addresses = $customer->getAddresses(); */
    /* if(current($addresses) != false){ */
    /*   $address = current($addresses); */
      $customerInfo = $address->getData();
    }
    else{
      $customerInfo = $customer->getData();
    }

    $customerStreet = (isset($customerInfo['street'])) ? $customerInfo['street'] : '';
    $customerCity = (isset($customerInfo['city'])) ? $customerInfo['city'] : '';
    $customerRegion = (isset($customerInfo['region'])) ? $customerInfo['region'] : '';
    $customerPost = (isset($customerInfo['postcode'])) ? $customerInfo['postcode'] : '';
    $customerCountry = (isset($customerInfo['country_id'])) ? $customerInfo['country_id'] : '';
    $customerPhone = (isset($customerInfo['telephone'])) ? $customerInfo['telephone'] : '';
    $customerEmail = (isset($customerInfo['email'])) ? $customerInfo['email'] : '';

    $pdfPage->setFont($bold, 12);
    $pdfPage->drawText($customer->getCompany(), 19, $height-117);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText($customer->getName(), 19, $height-129);
    $pdfPage->drawText($customerStreet, 19, $height-141);
    $pdfPage->drawText($customerCity, 19, $height-153);
    $pdfPage->drawText($customerRegion, 19, $height-165);
    $pdfPage->drawText($customerCountry, 19, $height-177);
    $pdfPage->setFont($bold, 12);
    $pdfPage->drawText('Phone:' , 19, $height-206);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText($customerPhone, 56, $height-206);
    $pdfPage->setFont($bold, 12);
    $pdfPage->drawText('Email:', 19, $height-218);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText($customer->getEmail(), 56, $height-218);


    return $pdfPage;
  }

  public function drawQuoteFooter($pdfPage, $startY, $height, $width, $font)
  {
    /** Draw Footer  **/
    $currentY = $startY;
    $pdfPage->drawLine(15, $currentY, $width-15, $currentY);
    $currentY = $currentY - 10;

    $footerText = array(
      'Purchase Order  (To be completed by the customer)',
      'Accept     (By checking here, you argee to purchase the items listed in this quote by one of the approved methods of payment given below)',
      'Payment Information',
      'Debit/Credit Card          Visa          MasterCard          Discovery          American Express',
      'Card Number:                                                                                   Expiration Date:                       Security Code:',
      '',
      'Check/Money Order',
      ' - Make your check or money order payable to AccelerEyes LLC. - Write the Quote Number from this form on the check.',
      ' - Mail your payment along with this purchase order form to AccelerEyes LLC, address shown above.',
      'Wire Transfer',
      ' - Use the following information for the wire transfer to AccelerEyes Silicon Valley Bank account.',
      'Routing No: 121140399 Account No: 3300702805 SWIFT Code: SVBKUS6S (International Wires Only)',
      ' - Bank Address: Silicon Valley Bank, 3003 Tasman Drive, Santa Clara, CA, 95054, USA',
      ' - Send an email to sales@accelereyes.com confirming payment amount and date with this form attached.'
    );

    $pdfPage->setFont($font, 8);
    foreach($footerText as $line)
    {
      $pdfPage->drawText($line, 16, $currentY);
      $currentY -= 10;
    }

    return $pdfPage;
  }

  function currDir(){
    $filename = explode("/", __FILE__); // THIS WILL BREAK DOWN THE PATH INTO AN ARRAY
    $filename2 = '';
    for( $i = 0; $i < (count($filename) - 1); ++$i ) {
      $filename2 .= $filename[$i].'/';
    }
    return $filename2;
  } 

}