<?php

class Accelereyes_LicenseLibjacket_AdminController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {
        if ($this->getRequest()->getQuery('ajax'))
        {
            $this->_forward('grid');
            return;
        }

        $this->loadLayout()
            ->_setActiveMenu('sales/licenses')
            ->_addContent($this->getLayout()->createBlock('licenselibjacket/admin_main', 'licenses'))
            ->renderLayout();
    }

    public function trialAction()
    {

        if ($this->getRequest()->getQuery('ajax'))
        {
            $this->_forward('trial_grid');
            return;
        }

        $this->loadLayout()
            ->_setActiveMenu('sales/licenses')
            ->_addContent($this->getLayout()->createBlock('licenselibjacket/admin_trial', 'licenses'))
            ->renderLayout();
    }

    public function gridAction()
    {
        $this->getResponse()->setBody($this->getLayout()->createBlock('licenselibjacket/admin_main_grid')->toHtml());
    }


    public function trial_gridAction()
    {
        $this->getResponse()->setBody($this->getLayout()->createBlock('licenselibjacket/admin_trial_grid')->toHtml());
    }

    public function deleteAction()
    {
        $licenseId = $this->getRequest()->getParam('id', false);

        try {
            Mage::getModel('licenselibjacket/license')->setId($licenseId)->delete();
            Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('licenselibjacket')->__('License successfully deleted'));
            $this->getResponse()->setRedirect($this->getUrl('*/*/'));

            return;
        } catch (Exception $e) {
            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }
    }

    public function newAction()
    {
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('licenselibjacket/admin_customer'))
            ->renderLayout();
    }

    public function createAction()
    {
        $this->loadLayout()
            ->_addContent($this->getLayout()->createBlock('licenselibjacket/admin_new'))
            ->renderLayout();
    }

    public function postAction()
    {
        $postProcessDestination = '*/*/';

        if ($data = $this->getRequest()->getPost()) {

            $data['purchase_date'] = strtotime($data['purchase_date']);
            $data['maintenance_date'] = strtotime($data['maintenance_date']);
            $data['support_date'] = strtotime($data['support_date']);

            if (!empty($data['expiration_date'])){
                $data['expiration_date'] = strtotime($data['expiration_date']);
            }

            if ($data['user_type']=='trial')
            {
                $data['machine_id'] = 'JUSTIN:BAILEY';
                $postProcessDestination = '*/*/trial';
            }

            if ($data['order_number'] == 0)
            {
                $data['order_number'] = null;
            }

            for($i=0; $i < (0+$data['lic_qty']); $i++) {

                $license = Mage::getModel('licenselibjacket/license')->setData($data);
                try {

                    $license->setLicenseCode($license->generateLicenseCode());
                    $license->setVersion(Mage::getModel('versionlibjacket/version')->getCurrentVersionNumber());
                    $license->save();
                    if($license->getUserType()=='trial')
                    {
                        $license->generateTrialLicense(Mage::getModel('versionlibjacket/version')->getCurrentVersionNumber());
                    }
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License
                            Created Successfully'));

                } catch (Exception $e) {

                    die($e->getMessage());
                    Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

                }

            }

        }

        $this->getResponse()->setRedirect($this->getUrl($postProcessDestination));

        return;
    }

    public function editAction()
    {
        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('licenselibjacket/admin_edit'));
        $this->renderLayout();
    }

    public function regenerateAction()
    {

        $licenseId = $this->getRequest()->getParam('id', false);
        $license = Mage::getModel('licenselibjacket/license')->load($licenseId);
        $license->generateFlexLicense($license->getVersion());

        Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License Regenerated Successfully'));

        $this->getResponse()->setRedirect($this->getUrl('*/*/'));

    }


    public function saveAction()
    {

        $postProcessDestination = '*/*/';

        $licenseId = $this->getRequest()->getParam('id', false);
        if($data = $this->getRequest()->getPost()) {

            $data['purchase_date'] = strtotime($data['purchase_date']);
            $data['maintenance_date'] = strtotime($data['maintenance_date']);
            $data['support_date'] = strtotime($data['support_date']);

            if (!empty($data['expiration_date'])){
                $data['expiration_date'] = strtotime($data['expiration_date']);
            }

            if ($data['user_type'] == 'trial')
            {
                $postProcessDestination = '*/*/trial/';
            }

            if ($data['order_number'] == 0)
            {
                $data['order_number'] = null;
            }

            $license = Mage::getModel('licenselibjacket/license')->load($licenseId)->addData($data);
            try {

                $license->setLicenseNumber($licenseId)->save();

                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('license')->__('License Edited Successfully'));
                $this->getResponse()->setRedirect($this->getUrl($postProcessDestination));
                return;

            } catch (Exception $e) {

                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());

            }

        }

        $this->_redirectReferer();
    }

    public function exportCsvAction()
    {

        $fileName   = 'arrayfirelicenses.csv';
        $content    = $this->getLayout()->createBlock('licenselibjacket/admin_main_grid')
            ->getCsv();

        $this->_prepareDownloadResponse($fileName, $content);

    }

    public function exportTrialCsvAction()
    {

        $fileName   = 'arrayfiretrials.csv';
        $content    = $this->getLayout()->createBlock('licenselibjacket/admin_trial_grid')
            ->getCsv();

        $this->_prepareDownloadResponse($fileName, $content);

    }



}