<?php

class Accelereyes_License_AllocateController extends Mage_Core_Controller_Front_Action
{

    public function indexAction()
    {
        $customerId = Mage::getModel('customer/session')->getCustomer()->getId();
        $orderTotals = Mage::getModel('license/order')
            ->getCustomerUnallocatedTotals($customerId);
        $orderNumber = Mage::getModel('license/order')
            ->getCustomerUnallocatedOrderNumber($customerId);

        // If the order only has 1 base license, skip the allocation.
        if($orderTotals['base'] == 1) {
            $success = Mage::getModel('license/order')->generateSingleLicense($customerId, $orderNumber);
            if($success) {
                header('Location: ' . Mage::getBaseUrl() . 'licenses');
                exit();
            }
        }

        $this->loadLayout();
        $this->getLayout()
            ->getBlock('content')
            ->append($this->getLayout()->createBlock('license/allocate'));
        $this->getLayout()->getBlock('head')
            ->setTitle($this->__('AccelerEyes - Allocate Licenses'));
        $this->renderLayout();
    }

    public function postAction()
    {
        $customerId = Mage::getModel('customer/session')->getCustomer()->getId();
        $groupModel = Mage::getModel('customer/group');
        $customerGroupId = Mage::getModel('customer/session')->getCustomerGroupId();
        $customerGroupName = $groupModel
            ->load($customerGroupId)
            ->getCustomerGroupCode();
        $postData = $this->getRequest()->getPost();

        // Sanitize post data.
        foreach($postData as $datum){ $datum = intval($datum); }

        // Get the totals for all oustanding license orders and of the post data.
        $orderTotals = Mage::getModel('license/order')
            ->getCustomerUnallocatedTotals($customerId);
        $postTotals = $this->getPostTotals($postData, $orderTotals['base']);

        $orderNumber = Mage::getModel('license/order')
            ->getCustomerUnallocatedOrderNumber($customerId);

        /**
         * This section checks that the user has not allocated to many
         * or too few products.  Gives the user a warning and stops the
         * creation of licenses.
         */
        $products = Mage::getModel('license/order')->getProductArray();
        $badRequest = false;
        foreach($products as $prod)
        {
            if($postTotals[$prod] > $orderTotals[$prod])
            {
                $badRequest = true;
                Mage::getSingleton('core/session')->addError(
                    'You tried to allocate ' . $postTotals[$prod]
                    . ' of the ' . strtoupper($prod)
                    . ' product but you have only purchased ' . $orderTotals[$prod] . '.'
                    );
            }
            if($postTotals[$prod] < $orderTotals[$prod])
            {
                $badRequest = true;
                Mage::getSingleton('core/session')->addError(
                    'You tried to allocate ' . $postTotals[$prod]
                    . ' of the ' . strtoupper($prod)
                    . ' product but you have purchased ' . $orderTotals[$prod] . '.'
                    );
            }
        }
        if($badRequest)
        {
            header('Location: ' . Mage::getBaseUrl() . 'license/allocate');
            exit();
            return;
        }

        // Set customer type.
        $customerType = 'commercial';
        if($customerGroupName=='Student'){
            $customerType = 'student';
        } elseif($customerGroupName=='Academic') {
            $customerType = 'academic';
        } elseif($customerGroupName=='Government / Research') {
            $customerType = 'government';
        }

        $version = Mage::getModel('version/version')->getCurrentVersionNumber();

        for($i=0; $i<$orderTotals['base']; $i++)
        {
            $license = Mage::getModel('license/license');
            $jla = (isset($postData['jla'.$i])) ? $postData['jla'.$i] : 0;
            $sla = (isset($postData['sla'.$i])) ? $postData['sla'.$i] : 0;
            $sdk = (isset($postData['sdk'.$i])) ? $postData['sdk'.$i] : 0;
            $jmc = (isset($postData['jmc'.$i])) ? $postData['jmc'.$i] : 0;
            $mgl = (isset($postData['mgl'.$i])) ? $postData['mgl'.$i] : 0;
            $hpc = (isset($postData['hpc'.$i])) ? $postData['hpc'.$i] : 0;
            $sms = 0;
            $phone = 0;
            if(isset($postData['sms'.$i]))
            {
                $sms = ($postData['sms'.$i] == 'on') ? 1 : 0;
            }
            if(isset($postData['phone'.$i]))
            {
                $phone = ($postData['phone'.$i] == 'on') ? 1 : 0;
            }
            $itemSku = 666;

            $month = date('m');
            $day = date('d');
            $year = date('Y');
      
      
            error_log('License Order Post: \n' . print_r($postData, true));

            $license->setMaintenanceDate(mktime(0,0,0,$month, $day, $year+1+$sms));
            $supportDate = ($phone > 0) ? mktime(0,0,0,$month, $day, $year+1) : 0; 
            $license->setSupportDate($supportDate);

            $license->setMgo($mgl);
            $license->setMgl($mgl);
            $license->setOrderNumber($orderNumber);
            $license->setCn(0);
            $license->setSdk($sdk);
            $license->setJmc($jmc);
            $license->setJla($jla);
            $license->setSla($sla);
            $license->setGfxToolbox(1);
            $license->setCustomerId($customerId);
            $license->setUserType($customerType);
            $license->setPurchaseDate(mktime(0,0,0,$month, $day, $year));
            $license->setProductSku('666');
            $license->setPaid(1);
            $license->setVersion($version);
            $license->setLicenseCode($license->generateLicenseCode());
            $license->save();

        }

        Mage::getModel('license/order')->setCustomerLicenseOrdersAllocated($customerId);

        header('Location: ' . Mage::getBaseUrl() . 'licenses');
        exit();
    }

    /**
     * Takes in array of post data and the number of base licenses.
     * Returns an array with all totals for the post data.
     */
    private function getPostTotals($postData, $baseLicenses)
    {

        $totals = Mage::getModel('license/order')->getEmptyTotalsArray();

        for($i=0; $i<$baseLicenses; $i++)
        {
            $totals['jla'] += (isset($postData['jla'.$i])) ? $postData['jla'.$i] : 0;
            $totals['sla'] += (isset($postData['sla'.$i])) ? $postData['sla'.$i] : 0;
            $totals['sdk'] += (isset($postData['sdk'.$i])) ? $postData['sdk'.$i] : 0;
            $totals['jmc'] += (isset($postData['jmc'.$i])) ? $postData['jmc'.$i] : 0;
            $totals['mgl'] += (isset($postData['mgl'.$i])) ? $postData['mgl'.$i] : 0;
            $totals['hpc'] += (isset($postData['hpc'.$i])) ? $postData['hpc'.$i] : 0;
        }

        return $totals;
    }

}